/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cvu;

import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.library.util.cvu.CVUHelper;

public class CVUValidationStatusMessage
extends ValidationStatusMessage {
    public CVUValidationStatusMessage(String message) {
        super(message);
        this.updateExtraDetails();
    }

    public CVUValidationStatusMessage(Throwable cause) {
        super(cause);
        this.updateExtraDetails();
    }

    public CVUValidationStatusMessage(String message, Severity severity) {
        super(message, severity);
        this.updateExtraDetails();
    }

    public CVUValidationStatusMessage(ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, null, messageArgs);
        this.updateExtraDetails();
    }

    public CVUValidationStatusMessage(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.updateExtraDetails();
    }

    protected Content computeExtraDetails() {
        PlainContent content = null;
        CVUHelper helper = CVUHelper.getInstance();
        if (!helper.isResultSetDirty()) {
            content = helper.getExtraDetails();
            helper.setResultSetDirty(true);
        }
        return content;
    }

    protected void updateExtraDetails() {
        ErrorInfo errorInfo = this.getErrorInfo();
        if (errorInfo != null) {
            errorInfo.setExtraDetails(this.computeExtraDetails());
        }
    }
}

